export default class Card{

    #width;
    #height;

    constructor(id){
        this.#width = 32;           // Largeur de la carte
        this.#height = 48;          // Hauteur de la carte
        this.id = id;               // ID de la carte sur le spritesheet (0 -> 51)
        this.isFlipped = false;     // Etat de la carte (retournée ou non)
        this.isBig = false;         // Taille x2 si vrai
        this.isCenter = false;      // Origine du dessin au centre de la carte si vrai
    }

    get imgX(){ //Position X sur le spritesheet
        if(this.isFlipped){ return this.width * (this.id % 13); }   //Face
        if(this.isBig){ return this.#width; }                        //Dos grande taille
        return 0;                                                   //Dos taille normale
    }               
    get imgY(){ //Position Y sur le spritesheet
        if(this.isFlipped){ return this.#height * Math.floor(this.id / 13); }    //Face
        return 192;                                                              //Dos
    }
    get width(){ 
        if(!this.isFlipped && this.isBig){ return this.#width*2; }
        return this.#width;
    }
    get height(){ 
        if(!this.isFlipped && this.isBig){ return this.#height*2; }
        return this.#height;
    }

    get sign(){ return Math.floor(this.id/13); }
    get color(){ return this.sign%2; }

    draw(ctx) {
        const img = APP.images['cards'];
        if(!img) return;    // Si l'image de carte n'est pas chargée, on empêche le dessin
        ctx.drawImage(img, this.imgX, this.imgY, this.width, this.height, -(this.width/2), -(this.height/2), this.width, this.height);
    }

}